﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Data.Linq.Mapping; //atrubuty klasy encji
using System.Data.Linq; //DataContext

namespace LINQ_to_SQL
{
    public partial class Form1 : Form
    {
        TelefonyDataContext bazaDanychTelefony = new TelefonyDataContext();

        public Form1()
        {
            InitializeComponent();                        
            new Form2().Show();
            new Form3().Show();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            // pobieranie danych z tabeli
            TelefonyDataContext bazaDanychTelefony = new TelefonyDataContext();
            var listaOsob = bazaDanychTelefony.ListaOsobs;

            //pobieranie kolekcji
            var listaOsobPelnoletnich = from osoba in listaOsob where osoba.Wiek >= 18 select osoba;

            //wyświetlanie pobranej kolekcji
            string s = "Lista osób pełnoletnich:\n";
            foreach (ListaOsob osoba in listaOsobPelnoletnich)
                s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);

            //informacje o pobranych danych
            MessageBox.Show("Typ: " + listaOsobPelnoletnich.GetType().FullName);
            MessageBox.Show("Ilość pobranych rekordów: " + listaOsobPelnoletnich.Count().ToString());
            MessageBox.Show("Suma wieku wybranych osób: "
               + listaOsobPelnoletnich.Sum(osoba => osoba.Wiek).ToString());
            MessageBox.Show("Imię pierwszej osoby: " + listaOsobPelnoletnich.First().Imię);

            s = "Pełna lista osób:\n";
            foreach (ListaOsob osoba in listaOsob) s += osoba.Imię + " " + osoba.Nazwisko +
               " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);
        }
    }
}
